unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Buttons, ExtCtrls, AppEvnts;

const sbCapsLock : Integer = 5;
const sbNumLock  : Integer = 6;
const sbInsert   : Integer = 7;


type
  TForm2 = class(TForm)
    ApplicationEvents1: TApplicationEvents;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    StatusBar: TStatusBar;
    procedure StatusBarDrawPanel(StatusBar: TStatusBar; Panel: TStatusPanel;
      const Rect: TRect);
    procedure BitBtn1Click(Sender: TObject);
    procedure ApplicationEvents1Idle(Sender: TObject; var Done: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TForm2.BitBtn1Click(Sender: TObject);
begin
	Close();
end;

procedure TForm2.StatusBarDrawPanel(StatusBar: TStatusBar; Panel: TStatusPanel; const Rect: TRect);
var
	fn  : String;
	bmp : Graphics.TBitmap;

begin
	fn  := '';
	bmp := TBitmap.Create();

	fn :=  'bmp0' + IntToStr(Panel.Index + 1) + '.bmp';
   if FileExists(fn) then
   begin
   	bmp.LoadFromFile(fn);
      StatusBar.Canvas.Draw(Rect.Left + 2, Rect.Top + 2, bmp);
      StatusBar.Canvas.TextOut(Rect.Left + 23, Rect.Top + 2, Panel.Text);
   end;

	FreeAndNil(bmp);
end;

procedure TForm2.ApplicationEvents1Idle(Sender: TObject; var Done: Boolean);
begin
   if GetKeyState(VK_CAPITAL) > 0 then
   begin
   	StatusBar.Panels.Items[sbCapsLock].Text :=  'Caps';
   end
   else begin
   	StatusBar.Panels.Items[sbCapsLock].Text :=  '';
   end;

   if GetKeyState(VK_NUMLOCK) > 0 then
   begin
   	StatusBar.Panels.Items[sbNumLock].Text :=  'Num';
   end
   else begin
   	StatusBar.Panels.Items[sbNumLock].Text :=  '';
   end;

   if GetKeyState(VK_INSERT) > 0 then
   begin
   	StatusBar.Panels.Items[sbInsert].Text :=  'Ins';
   end
   else begin
   	StatusBar.Panels.Items[sbInsert].Text :=  '';
   end;
end;

end.
